/*
 * MATLAB Compiler: 3.0
 * Date: Sat Oct 25 23:14:23 2003
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-B" "sgl" "-m" "-W"
 * "main" "-L" "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "-W" "mainhg"
 * "libmwsglm.mlib" "cs2.m" 
 */
#include "satnetwork.h"
#include "libmatlbm.h"
static mxArray * _mxarray0_;
static mxArray * _mxarray1_;
static mxArray * _mxarray2_;
static mxArray * _mxarray3_;
static mxArray * _mxarray4_;
static mxArray * _mxarray5_;

static mxChar _array7_[1] = { ' ' };
static mxArray * _mxarray6_;

static mxChar _array9_[17] = { 'I', 'S', 'L', ' ', 'o', 'p', 't', 'i', 'o',
                               'n', ' ', 'e', 'r', 'r', 'o', 'r', '!' };
static mxArray * _mxarray8_;
static mxArray * _mxarray10_;
static mxArray * _mxarray11_;

void InitializeModule_satnetwork(void) {
    _mxarray0_ = mclInitializeDouble(6.3);
    _mxarray1_ = mclInitializeDouble(26398000.0);
    _mxarray2_ = mclInitializeDouble(0.0);
    _mxarray3_ = mclInitializeDouble(50.0);
    _mxarray4_ = mclInitializeDouble(1.0);
    _mxarray5_ = mclInitializeDouble(2.0);
    _mxarray6_ = mclInitializeString(1, _array7_);
    _mxarray8_ = mclInitializeString(17, _array9_);
    _mxarray10_ = mclInitializeDouble(3.0);
    _mxarray11_ = mclInitializeDouble(20.0);
}

void TerminateModule_satnetwork(void) {
    mxDestroyArray(_mxarray11_);
    mxDestroyArray(_mxarray10_);
    mxDestroyArray(_mxarray8_);
    mxDestroyArray(_mxarray6_);
    mxDestroyArray(_mxarray5_);
    mxDestroyArray(_mxarray4_);
    mxDestroyArray(_mxarray3_);
    mxDestroyArray(_mxarray2_);
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * Msatnetwork(mxArray * * NGW,
                             mxArray * * personnel,
                             int nargout_,
                             mxArray * constel,
                             mxArray * ISL,
                             mxArray * Nmin,
                             mxArray * NPmin,
                             mxArray * Afoot);

_mexLocalFunctionTable _local_function_table_satnetwork
  = { 0, (mexFunctionTableEntry *)NULL };

/*
 * The function "mlfSatnetwork" contains the normal interface for the
 * "satnetwork" M-function from file "c:\tmp\cs2\build\satnetwork.m" (lines
 * 1-22). This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
mxArray * mlfSatnetwork(mxArray * * NGW,
                        mxArray * * personnel,
                        mxArray * constel,
                        mxArray * ISL,
                        mxArray * Nmin,
                        mxArray * NPmin,
                        mxArray * Afoot) {
    int nargout = 1;
    mxArray * GWKLOC = NULL;
    mxArray * NGW__ = NULL;
    mxArray * personnel__ = NULL;
    mlfEnterNewContext(2, 5, NGW, personnel, constel, ISL, Nmin, NPmin, Afoot);
    if (NGW != NULL) {
        ++nargout;
    }
    if (personnel != NULL) {
        ++nargout;
    }
    GWKLOC
      = Msatnetwork(
          &NGW__, &personnel__, nargout, constel, ISL, Nmin, NPmin, Afoot);
    mlfRestorePreviousContext(
      2, 5, NGW, personnel, constel, ISL, Nmin, NPmin, Afoot);
    if (NGW != NULL) {
        mclCopyOutputArg(NGW, NGW__);
    } else {
        mxDestroyArray(NGW__);
    }
    if (personnel != NULL) {
        mclCopyOutputArg(personnel, personnel__);
    } else {
        mxDestroyArray(personnel__);
    }
    return mlfReturnValue(GWKLOC);
}

/*
 * The function "mlxSatnetwork" contains the feval interface for the
 * "satnetwork" M-function from file "c:\tmp\cs2\build\satnetwork.m" (lines
 * 1-22). The feval function calls the implementation version of satnetwork
 * through this function. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
void mlxSatnetwork(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[5];
    mxArray * mplhs[3];
    int i;
    if (nlhs > 3) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: satnetwork Line: 5 Column:"
            " 1 The function \"satnetwork\" was called with m"
            "ore than the declared number of outputs (3)."),
          NULL);
    }
    if (nrhs > 5) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: satnetwork Line: 5 Column"
            ": 1 The function \"satnetwork\" was called with"
            " more than the declared number of inputs (5)."),
          NULL);
    }
    for (i = 0; i < 3; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 5 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 5; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 5, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4]);
    mplhs[0]
      = Msatnetwork(
          &mplhs[1],
          &mplhs[2],
          nlhs,
          mprhs[0],
          mprhs[1],
          mprhs[2],
          mprhs[3],
          mprhs[4]);
    mlfRestorePreviousContext(
      0, 5, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4]);
    plhs[0] = mplhs[0];
    for (i = 1; i < 3 && i < nlhs; ++i) {
        plhs[i] = mplhs[i];
    }
    for (; i < 3; ++i) {
        mxDestroyArray(mplhs[i]);
    }
}

/*
 * The function "Msatnetwork" is the implementation version of the "satnetwork"
 * M-function from file "c:\tmp\cs2\build\satnetwork.m" (lines 1-22). It
 * contains the actual compiled code for that M-function. It is a static
 * function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * % function satNetwork
 * % by Darren Chang (darrenz@mit.edu)
 * % last modified on 9/7/02
 * 
 * function [GWKLOC,NGW,personnel] = satNetwork(constel,ISL,Nmin,NPmin,Afoot)
 */
static mxArray * Msatnetwork(mxArray * * NGW,
                             mxArray * * personnel,
                             int nargout_,
                             mxArray * constel,
                             mxArray * ISL,
                             mxArray * Nmin,
                             mxArray * NPmin,
                             mxArray * Afoot) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_satnetwork);
    mxArray * GWKLOC = NULL;
    mxArray * ans = NULL;
    mxArray * Afoot_GS = NULL;
    mclCopyArray(&constel);
    mclCopyArray(&ISL);
    mclCopyArray(&Nmin);
    mclCopyArray(&NPmin);
    mclCopyArray(&Afoot);
    /*
     * 
     * GWKLOC	= 6.3;         % ground system thousand lines of code, estimated based on GlobalStar, ARIES, ORBCOMM, and Starnet
     */
    mlfAssign(&GWKLOC, _mxarray0_);
    /*
     * 
     * Afoot_GS = 2.6398e7;    % footprint area of Globalstar in km^2
     */
    mlfAssign(&Afoot_GS, _mxarray1_);
    /*
     * 
     * if ISL == 0        % no ISL
     */
    if (mclEqBool(mclVa(ISL, "ISL"), _mxarray2_)) {
        /*
         * NGW	= round(50*Afoot_GS/Afoot);	 % number of GW is inversely proportional to the footprint area
         */
        mlfAssign(
          NGW,
          mlfRound(
            mclMrdivide(
              mclMtimes(_mxarray3_, mclVv(Afoot_GS, "Afoot_GS")),
              mclVa(Afoot, "Afoot"))));
    /*
     * elseif ISL == 1    % with ISL
     */
    } else if (mclEqBool(mclVa(ISL, "ISL"), _mxarray4_)) {
        /*
         * NGW = NPmin*2;   % 2 gound stations per plane   
         */
        mlfAssign(NGW, mclMtimes(mclVa(NPmin, "NPmin"), _mxarray5_));
    /*
     * else
     */
    } else {
        /*
         * disp(' ');
         */
        mlfDisp(_mxarray6_);
        /*
         * disp('ISL option error!');
         */
        mlfDisp(_mxarray8_);
    /*
     * end;
     */
    }
    /*
     * personnel= (NGW*3 + 2*10)*(24/8);	% number of personnel required 24 hours a day 
     */
    mlfAssign(
      personnel,
      mclMtimes(
        mclPlus(mclMtimes(mclVv(*NGW, "NGW"), _mxarray10_), _mxarray11_),
        _mxarray10_));
    mclValidateOutput(GWKLOC, 1, nargout_, "GWKLOC", "satnetwork");
    mclValidateOutput(*NGW, 2, nargout_, "NGW", "satnetwork");
    mclValidateOutput(*personnel, 3, nargout_, "personnel", "satnetwork");
    mxDestroyArray(Afoot_GS);
    mxDestroyArray(ans);
    mxDestroyArray(Afoot);
    mxDestroyArray(NPmin);
    mxDestroyArray(Nmin);
    mxDestroyArray(ISL);
    mxDestroyArray(constel);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return GWKLOC;
    /*
     * % at all ground stations and 2 command centers
     * 
     */
}
